import { Link, useLocation } from 'react-router-dom'
import { motion } from 'framer-motion'
import { Headphones } from 'lucide-react'
import Footer from './Footer'
import './Layout.css'

const Layout = ({ children }) => {
  const location = useLocation()

  return (
    <div className="app-wrapper-lux">
      <header className="header-lux">
        <div className="container">
          <div className="header-content-lux">
            <Link to="/" className="logo-lux">
              <div className="logo-icon-lux">
                <Headphones size={24} strokeWidth={2} />
              </div>
              <span className="logo-text-lux">AudioLux</span>
            </Link>
            <nav className="nav-lux">
              <Link 
                to="/" 
                className={`nav-link-lux ${location.pathname === '/' ? 'active' : ''}`}
              >
                Мои аренды
              </Link>
              <Link 
                to="/rent" 
                className={`nav-link-lux ${location.pathname === '/rent' ? 'active' : ''}`}
              >
                Арендовать
              </Link>
            </nav>
          </div>
        </div>
      </header>

      <main className="main-content-lux">
        {children}
      </main>

      <Footer />
    </div>
  )
}

export default Layout

